#include "protheus.ch"

// *********************************************************************** //
// FI040ROT - Ponto de Entrada para Adicionar Botoes no FINA040            //
// @copyright (c) 2023-09-01 > Marcelo da Cunha > GDVIEW                  //
// *********************************************************************** //

User Function FI040ROT()
	********************
	LOCAL aRetu := aClone(paramixb)
	aadd(aRetu,{"Gerar Boleto","U_F040GERBOL",0,4,0,NIL})
	aadd(aRetu,{"Abrir Boleto","U_F040ABRBOL",0,4,0,NIL})
Return aRetu

User Function F040GERBOL()
	**********************
	LOCAL cArqBol
	If (Select("SE1") != 0)
		If Empty(SE1->E1_portado)
			Help("",1,"GDVIEW [FI040ROT]",,OemToAnsi("Banco no informado no cadastro de clientes (E1_PORTADO)!"),1,0)
			Return
		Elseif (SE1->E1_portado == "001") // BB
			cArqBol := u_GDVBBBOL()
		Endif
	Endif	
Return

User Function F040ABRBOL()
    **********************
    LOCAL cArqBol, cDirBol, cTempPath := GDVFW():getDirTemp()
    cDirBol := Alltrim(SuperGetMV("MV_RELT",.F.,"\spool\"))
    cDirBol += iif(!Right(cDirBol,1)$"/\",iif(IsSrvUnix(),"/","\"),"")
    cDirBol += "boletos"+iif(IsSrvUnix(),"/","\")
	If !(Right(cTempPath,1) $ "/\")
		cTempPath += iif(IsSrvUnix(),"/","\")
	Endif
	cArqBol := Alltrim(SE1->E1_gdvabol)
	If !Empty(cArqBol).and.File(cDirBol+cArqBol)
		If (__CopyFile(cDirBol+cArqBol,cTempPath+cArqBol))
			ShellExecute("Open",cArqBol,"",cTempPath,1)
		Endif
	Else
		Help("",1,"GDVIEW [FI040ROT]",,OemToAnsi("O boleto no foi gerado!"),1,0)
		Return
	Endif
Return
