#include "protheus.ch"

// *********************************************************************** //
// GDASORBPV - Ponto de Entrada atualizar informacoes antes de gravar PV   //
// @copyright (c) 2019-08-16 > Marcelo da Cunha  > GDVIEW                  //   
// *********************************************************************** //

User Function GDASORBPV()
    *********************
	LOCAL nx, cPedCli, nLinha := 0, nPCabPed := 0, nPItePed := 0
	LOCAL aCab := aClone(paramixb[1]), aIte := aClone(paramixb[2])
	For nx := 1 to Len(aIte)
		nPItePed := aScan(aIte[nx],{|x| Alltrim(x[1]) == "C6_PEDCLI" })
		If (nPItePed > 0)
			nLinha := nx
			Exit
		Endif
	Next nx
	If (nPItePed > 0).and.(nLinha > 0)
		cPedCli := aIte[nLinha,nPItePed]
		If Empty(cPedCli)
			cPedCli := "GDVAPP"
		Endif
		nPCabPed := aScan(aCab,{|x| Alltrim(x[1]) == "C5_PEDCLI" })
		If (nPCabPed == 0)
			aadd(aCab,{"C5_PEDCLI",cPedCli,nil})
		Else
			aCab[nPCabPed,2] := cPedCli
		Endif
	Endif
Return {aCab,aIte}
