#include "protheus.ch"

// *********************************************************************** //
// M460FIM - Ponto de entrada para gerar boleto de cobranca                //
// @copyright (c) 2023-09-01 > Marcelo da Cunha > GDVIEW                   //
// *********************************************************************** //

User Function M460FIM()
	*******************
	LOCAL lSE1
	// Gerar boletos de maneira automatica
	If (SA1->(FieldPos("A1_GDVGBOL")) > 0)
		SA1->(dbSetOrder(1)) ; SE1->(dbSetOrder(1))
		If SA1->(dbSeek(xFilial("SA1")+SF2->(F2_cliente+F2_loja))).and.(SA1->A1_gdvgbol == "S").and.!Empty(SA1->A1_bco1).and.!Empty(SF2->F2_cond)
			lSE1 := SE1->(dbSeek(xFilial("SE1")+SF2->(F2_prefixo+F2_doc)))
			If (lSE1).and.(SE1->E1_cliente == SF2->F2_cliente).and.!(Alltrim(SF2->F2_cond) $ SuperGetMV("GD_COBNCND",.F.,""))
				If (SA1->A1_bco1 == "001").and.(posicBanco(SA1->A1_bco1)) // BB
					u_GDVBBBOL(.F.,nil,"   ","zzz")
				Endif
			Endif
		Endif
	Endif
Return

Static Function posicBanco(xBanco)
    ******************************
	LOCAL lRetu := .F., cQryBco, cAlsBco
    // Posicionar no parametro do banco
	cQryBco := "SELECT EE.R_E_C_N_O_ MRECSEE FROM "+RetSqlName("SEE")+" EE "
	cQryBco += "WHERE EE.D_E_L_E_T_ = '' AND EE_FILIAL = '"+xFilial("SEE")+"' "
	cQryBco += "AND EE_CODIGO = '"+xBanco+"' AND EE_CODEMP <> '' ORDER BY 1 "
	cAlsBco := GDVDB():query(cQryBco)
	SEE->(dbSetOrder(1))
	If !(cAlsBco)->(Eof()).and.((cAlsBco)->MRECSEE > 0)
		SEE->(dbGoto((cAlsBco)->MRECSEE))
		lRetu := .T.
	Endif
	GDVDB():queryEnd(cAlsBco)
Return lRetu 
