#include "rwmake.ch"
#include "topconn.ch"
#include "protheus.ch"
#include "colors.ch"

// *********************************************************************** //
// M410STSS - Ponto de Entrada para enviar workflow do pedido de venda     //
// @copyright (c) 2019-07-12 > Marcelo da Cunha  > GDVIEW                  //   
// *********************************************************************** //

User Function M410STTS()
	*********************
	If (SuperGetMV("GD_PVENVIA",.F.,.F.))
		If (INCLUI.or.ALTERA).and.(SC5->C5_tipo == "N")
			MPedEnvCon()
		Endif
	Endif
Return

Static Function MPedEnvCon()
	************************
	LOCAL aListaWF := {}, nn
	LOCAL nItem := 0
	LOCAL nTotMerc := 0, nTotDzf := 0, nTotIpi := 0, nTotSit := 0, nTotFre := 0
	LOCAL cCodProc := "CONPED", cDescProc := "Confimacao de Pedido de Venda"
	LOCAL cDirWF := Alltrim(GetMV("MV_WFDIR")), cHTMLModelo := "M410STTS_template.html"
	LOCAL cSubject := "", cEmail := "", cFromName := "Workflow"
	LOCAL cLstCond := SuperGetMV("GD_PVLSTPG",.F.,"") //Lista de Condicoes de Pagamento Especiais
	LOCAL cEmaCond := SuperGetMV("GD_PVEMAPG",.F.,"") //Emails que recebem workflow referente a lista de Condicoes de Pagamento Especiais
	LOCAL cEmaAdic := SuperGetMV("GD_PVEMAAD",.F.,"") //Emails adicionais que recebem workflow dos pedidos de vendas
	LOCAL lEnvClie := SuperGetMV("GD_PVENVCL",.F.,.F.) //Parmetro para envio ou no para o cliente
	LOCAL lEnvVend := SuperGetMV("GD_PVENVVE",.F.,.F.) //Parmetro para envio ou no para o vendedor

    // Corrigir diretrio workflow
	If !(Right(cDirWF,1) $ "/\")
		cDirWF += iif(IsSrvUnix(),"/","\")
	Endif

    // Inicializao da Funcao Fiscal
	MaFisEnd()
	MaFisIni(SC5->C5_cliente,SC5->C5_lojaent,IIf(SC5->C5_tipo$'DB',"F","C"),SC5->C5_tipo,SC5->C5_tipocli,nil,nil,nil,nil,"MATA461")

    // Alimento itens do e-mail para o supervisor
	nItem := 0
	SA1->(dbSetOrder(1)) ; SA4->(dbSetOrder(1)) ; SE4->(dbSetOrder(1))
	SC6->(dbSetOrder(1)) ; SA3->(dbSetOrder(1)) ; SB1->(dbSetOrder(1)) ; SF4->(dbSetOrder(1))
	SC6->(dbSeek(xFilial("SC6")+SC5->C5_num,.T.))
	While !SC6->(Eof()).and.(xFilial("SC6") == SC6->C6_filial).and.(SC6->C6_num == SC5->C5_num)
		SB1->(dbSeek(xFilial("SB1")+SC6->C6_produto,.T.))
		SF4->(dbSeek(xFilial("SF4")+SC6->C6_tes,.T.))

		nItem++

		// Funcao para Calculo Fiscal
		MaFisAdd(SC6->C6_PRODUTO,; 			// 1-Codigo do Produto ( Obrigatorio )
		SC6->C6_TES,;	   	   				// 2-Codigo do TES ( Opcional )
		SC6->C6_QTDVEN,;  	   				// 3-Quantidade ( Obrigatorio )
		SC6->C6_PRUNIT,;	   				// 4-Preco Unitario ( Obrigatorio )
		SC6->C6_VALDESC,;  					// 5-Valor do Desconto ( Opcional )
		"",;	   			   				// 6-Numero da NF Original ( Devolucao/Benef )
		"",;								// 7-Serie da NF Original ( Devolucao/Benef )
		0,;					   				// 8-RecNo da NF Original no arq SD1/SD2
		0,;			   	   		  			// 9-Valor do Frete do Item ( Opcional )
		0,;					  				// 10-Valor da Despesa do item ( Opcional )
		0,;					   				// 11-Valor do Seguro do item ( Opcional )
		0,;									// 12-Valor do Frete Autonomo ( Opcional )
		SC6->C6_VALOR+SC6->C6_VALDESC ,; 	// 13-Valor da Mercadoria ( Obrigatorio )
		0)					   				// 14-Valor da Embalagem ( Opiconal )

		// Totalizadores do Pedido
		nTotDzf  += MaFisRet(nItem,"IT_DESCZF")
		nTotIpi  += MaFisRet(nItem,"IT_VALIPI")
		nTotSit  += MaFisRet(nItem,"IT_VALSOL")
		nTotMerc += SC6->C6_valor

		// Alimentando Array para Envio WF
		aadd(aListaWF,{SC6->C6_entreg,SC6->C6_item,SC6->C6_produto,SC6->C6_descri,SC6->C6_numpcom,SC6->C6_qtdven,SC6->C6_prcven,SC6->C6_valor,SC6->C6_um})

		SC6->(dbSkip())
	Enddo

    // Fechando funcoes fiscais
	aImposto := MaFisNFCab()
	MaFisEnd()

    // Verificando se existem itens para serem enviados    
	If (Len(aListaWF) <= 0)
		Return
	Endif

	If !SA1->(dbSeek(xFilial("SA1")+SC5->C5_cliente+SC5->C5_lojacli))
		Return
	Endif

	nTotFre := SC5->C5_frete

    // Montagem do Workflow de Aviso de Pedidos de Venda Includo e/ou Alterado
	cSubject := "[EMPFIL"+cEmpAnt+cFilAnt+"PEDVEN"+SC5->C5_num+"] Confirmacao de "+iif(ALTERA,"Alteracao","Inclusao")
	cSubject += " do Pedido de Venda "+SC5->C5_num+" | "+dtoc(MsDate())+" as "+Substr(Time(),1,5)

	oProcess := TWFProcess():New(cCodProc,cDescProc)
	oProcess:NewTask(cDescProc,cDirWF+cHTMLModelo)
	oProcess:oHtml:ValByName("USUARIO" ,iif(Type("oMainWnd")=="U","AUTOMATICO",cUserName))
	oProcess:oHtml:ValByName("DATA"    ,dtoc(MsDate()))
	oProcess:oHtml:ValByName("HORA"    ,Time())
	oProcess:oHtml:ValByName("EMPFIL"  ,SM0->M0_codigo+SM0->M0_codfil)
	oProcess:oHtml:ValByName("EMPRESA" ,Upper(Alltrim(SM0->M0_nomecom))+" - "+Upper(Alltrim(SM0->M0_filial)))
	oProcess:oHtml:ValByName("PROGRAMA",Alltrim(Funname()))
	oProcess:oHtml:ValByName("AMBIENTE",GetEnvServer())
	oProcess:oHtml:ValByName("Pedido"  ,SC5->C5_num )
	oProcess:oHtml:ValByName("Emissao" ,dtoc(SC5->C5_emissao) )
	oProcess:oHtml:ValByName("Cliente" ,Alltrim(SC5->C5_cliente)+"/"+Alltrim(SC5->C5_lojacli)+"-"+Alltrim(SA1->A1_nome) )
	oProcess:oHtml:ValByName("operac"  ,iif(ALTERA,"ALTERAO","INCLUSO"))

	If SA3->(dbSeek(xFilial("SA3")+SC5->C5_vend1))
		oProcess:oHtml:ValByName("Repres"  , Alltrim(SC5->C5_vend1)+"-"+Alltrim(SA3->A3_nome) )
	Else
		oProcess:oHtml:ValByName("Repres"  , "&nbsp;" )
	Endif

	If SA4->(dbSeek(xFilial("SA4")+SC5->C5_transp))
		oProcess:oHtml:ValByName("Transp"  , Alltrim(SC5->C5_transp)+"-"+Alltrim(SA4->A4_nome) )
	Else
		oProcess:oHtml:ValByName("Transp"  , "&nbsp;" )
	Endif

	If SE4->(dbSeek(xFilial("SE4")+SC5->C5_condpag))
		oProcess:oHtml:ValByName("CondPagto"  , Alltrim(SC5->C5_condpag)+"-"+Alltrim(SE4->E4_descri) )
	Else
		oProcess:oHtml:ValByName("CondPagto"  , "&nbsp;" )
	Endif

    // Mensagem nota fiscal
	If !Empty(SC5->C5_mennota)
		oProcess:oHtml:ValByName("MensNota"  , Alltrim(SC5->C5_mennota) )
	Else
		oProcess:oHtml:ValByName("MensNota"  , "&nbsp;" )
	Endif

	For nn := 1 to Len(aListaWF)
		AAdd( oProcess:oHtml:ValByName("Item.item")     , aListaWF[nn,2] )
		AAdd( oProcess:oHtml:ValByName("Item.produto")  , aListaWF[nn,3] )
		AAdd( oProcess:oHtml:ValByName("Item.descri")   , aListaWF[nn,4] )
		AAdd( oProcess:oHtml:ValByName("Item.pedcli")   , aListaWF[nn,5] )
		AAdd( oProcess:oHtml:ValByName("Item.qtdven")   , Transform(aListaWF[nn,6],PesqPict("SC6","C6_QTDVEN")) )
		AAdd( oProcess:oHtml:ValByName("Item.prcven")   , Transform(aListaWF[nn,7],PesqPict("SC6","C6_PRCVEN")) )
		AAdd( oProcess:oHtml:ValByName("Item.valor")    , Transform(aListaWF[nn,8],PesqPict("SC6","C6_VALOR")) )
		AAdd( oProcess:oHtml:ValByName("Item.um")  	    , aListaWF[nn,9] )
	Next nn

	oProcess:oHtml:ValByName("totpro" , Transform(nTotMerc,PesqPict("SC6","C6_VALOR")) )
	oProcess:oHtml:ValByName("subtri" , Transform(nTotSit ,PesqPict("SC6","C6_VALOR")) )
	oProcess:oHtml:ValByName("totfre" , Transform(nTotFre ,PesqPict("SC6","C6_VALOR")) )
	oProcess:oHtml:ValByName("totipi" , Transform(nTotIpi ,PesqPict("SC6","C6_VALOR")) )

	If (nTotDzf > 0)
		oProcess:oHtml:ValByName("desdzf"  , "Desconto ZFM" )
		oProcess:oHtml:ValByName("totdzf"  , Transform(nTotDzf,PesqPict("SC6","C6_VALOR")) )
	Else
		oProcess:oHtml:ValByName("desdzf"  , "&nbsp;" )
		oProcess:oHtml:ValByName("totdzf"  , "&nbsp;" )
	Endif
	oProcess:oHtml:ValByName("totped"  , "<b>"+Transform(nTotMerc+nTotSit+nTotFre+nTotIpi-nTotDzf,PesqPict("SC6","C6_VALOR"))+"</b>" )

	If (Len(aImposto) > 0)
		For nn := 1 to Len(aImposto)
			AAdd( oProcess:oHtml:ValByName("Impo.tipo") , aImposto[nn,2] )
			AAdd( oProcess:oHtml:ValByName("Impo.base") , Transform(aImposto[nn,3],"@E 999,999,999.99") )
			AAdd( oProcess:oHtml:ValByName("Impo.aliq") , Transform(aImposto[nn,4],"@E 999.99") )
			AAdd( oProcess:oHtml:ValByName("Impo.valor"), Transform(aImposto[nn,5],"@E 999,999,999.99") )
		Next nn
	Else
		AAdd( oProcess:oHtml:ValByName("Impo.tipo") , "&nbsp;" )
		AAdd( oProcess:oHtml:ValByName("Impo.base") , "&nbsp;" )
		AAdd( oProcess:oHtml:ValByName("Impo.aliq") , "&nbsp;" )
		AAdd( oProcess:oHtml:ValByName("Impo.valor"), "&nbsp;" )
	Endif

	If (lEnvVend) .And. !Empty(SA3->A3_email) .And. SA3->A3_MSBLQL != "1"
		cEmail += Alltrim(SA3->A3_email)+";"
	Endif

	If (lEnvClie) .And. !Empty(SA1->A1_email) .And. SA1->A1_MSBLQL != "1"
		cEmail += Alltrim(SA1->A1_email)+";"
	Endif

    //Lista de e-mails que recebem workflows quando a condio de pagamento for especial (exemplo: financeiro quer receber o wf dos pedidos na condio a vista)
	If !Empty(cEmaCond).and.!Empty(cLstCond).and.(SC5->C5_condpag $ cLstCond)
		cEmail += Alltrim(cEmaCond)+";"
	Endif

    //Lista de e-mails adicionais que recebem workflows dos pedidos de venda
	If !Empty(cEmaAdic)
		cEmail += Alltrim(cEmaAdic)+";"
	Endif
	cEmail := formatMail(cEmail)
	If !Empty(cEmail)
		oProcess:cTo := cEmail
	Endif
	If SuperGetMV("GD_ENCUTF8",.F.,.T.)
		cSubject := EncodeUTF8(cSubject)
	Endif
	oProcess:cSubject := cSubject
	oProcess:cFromName:= cFromName
	oProcess:Start()
	oProcess:Finish()

Return

// Funcao para formatar o e-mail com o dominio
Static Function formatMail(xEmail)
	******************************
	LOCAL cRetu := Alltrim(xEmail), aLista, nn, nPos
	LOCAL cDomain := SuperGetMV("GD_DOMAIN",.F.,"")
	If !Empty(cDomain)
		aLista := StrToKArr(xEmail,";")
		If (Len(aLista) > 0)
			cRetu := ""
			For nn := 1 to Len(aLista)
				cRetu += Alltrim(aLista[nn])
				nPos := AT("@",aLista[nn])
				If (nPos == 0)
					cRetu += "@"+cDomain
				Endif
				cRetu += ";"
			Next nn
		Endif
	Endif
Return cRetu
