#include "protheus.ch"

// *********************************************************************** //
// MT131WF - Ponto de entrada para envio do e-mail de cotacao		       //
// @copyright (c) 2023-03-22 > Marcelo da Cunha - GDVIEW     			   //
// *********************************************************************** //

User Function MT131WF()
    *******************
	LOCAL aParam := Paramixb
    LOCAL cCotacao, nn

    // Logica para buscar numero da cotacao, pois rotina padrao estava retornando em branco
    cCotacao := aParam[1]
    If Empty(cCotacao)
        For nn := 1 to Len(aParam[2])
            If !Empty(aParam[2,nn])
                cCotacao := aParam[2,nn]
                Exit
            Endif
        Next nn
    Endif
    If Empty(cCotacao)
        cCotacao := SC8->C8_num
    Endif
    conout("===============================================")
    conout("MT131WF[001] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao)
    sendQuotation() // Enviar e-mails com a cotao para atualizacao
    conout("MT131WF[009] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao)
    conout("===============================================")

Return

Static Function sendQuotation()
    ***************************
    LOCAL cCotacao := paramixb[1], cCodFor, cLojFor, cToken
    LOCAL cQry, cAls, lSQLOk, cTit, cMsg, cEmail, cCopia
    LOCAL cUrlCot := Alltrim(SuperGetMV("GD_COMURLC",.F.,""))
    LOCAL lFldCntt := SC8->(FieldPos("C8_GDVCNTT")) > 0
    LOCAL lFldToke := SC8->(FieldPos("C8_GDVTOKE")) > 0
    conout("MT131WF[002] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao)
    If (Type("__aGDVFOR") == "A").and.!Empty(cUrlCot).and.(lFldCntt).and.(lFldToke)
        cEmail := Alltrim(UsrRetMail(RetCodUsr()))
        conout("MT131WF[004] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao+" - cEmail: "+cEmail)
        cQry := "SELECT C8_FORNECE,C8_LOJA FROM "+RetSqlName("SC8")+" C8 "
        cQry += "INNER JOIN "+RetSqlName("SA2")+" A2 ON (A2.D_E_L_E_T_ = '' "
        cQry += "AND A2_FILIAL = '"+xFilial("SA2")+"' AND A2_COD = C8_FORNECE AND A2_LOJA = C8_LOJA) "
        cQry += "WHERE C8.D_E_L_E_T_ = '' AND C8_FILIAL = '"+xFilial("SC8")+"' "
        cQry += "AND C8_NUM = '"+cCotacao+"' AND C8_NUMPED IN ('','XXXXXX') "
        cQry += "GROUP BY C8_FORNECE,C8_LOJA ORDER BY C8_FORNECE,C8_LOJA "
        cAls := GDVDB():query(cQry)
        While !(cAls)->(Eof())
            cCodFor := (cAls)->C8_fornece
            cLojFor := (cAls)->C8_loja
            If ((nPosFor := (aScan(__aGDVFOR, {|x| x[1]+x[2] == cCodFor+cLojFor }))) > 0)
                If !Empty(__aGDVFOR[nPosFor,6]).or.!Empty(cEmail) // Email
                    // Atualizar registros para envio
                    cToken := MD5(cCodFor+cLojFor+Time(),2)
                    cQry := "UPDATE "+RetSqlName("SC8")+" SET "
                    cQry += "C8_GDVTOKE='"+cToken+"',"
                    cQry += "C8_GDVCNTT='"+__aGDVFOR[nPosFor,4]+"',"
                    cQry += "C8_OBS=CONVERT(VARBINARY(200),'') "
                    If (SC8->(FieldPos("C8_GDVIUSU")) > 0)
		                cQry += ",C8_GDVIUSU='"+Alltrim(cUserName)+"',C8_GDVIDAT='"+dtos(MsDate())+"',C8_GDVIHOR='"+Time()+"' "
                	Endif
                    cQry += "WHERE D_E_L_E_T_ = '' AND C8_FILIAL = '"+xFilial("SC8")+"' AND C8_NUM = '"+cCotacao+"' "
                    cQry += "AND C8_FORNECE = '"+cCodFor+"' AND C8_LOJA = '"+cLojFor+"' AND C8_NUMPED IN ('','XXXXXX') "
                    lSQLOk := (TCSQLExec(cQry) >= 0)
                    If (lSQLOk)
                        cTit := "Solicitao de Cotao "+cCotacao
                        cMsg := "A Solida solicita o preenchimento da cotao "+cCotacao+". "
                        cMsg += "Favor clicar <a href='"+cUrlCot+"?id="+Encode64(cCotacao)+"&token="+Encode64(cToken)+"'>"
                        cMsg += "<b>AQUI</b></a> para atualizar as informaes."
                        // Enviar aviso por e-mail com a cotao
                        cCopia := ""
                        If !Empty(cEmail).and.!(cEmail $ __aGDVFOR[nPosFor,6])
                            cCopia := cEmail // Enviar copia para o usurio que gerou a cotao
                        Endif
                        conout("MT131WF[005] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao+" - Link p/ Fornecedor: "+__aGDVFOR[nPosFor,6])
                        u_GDVWFAviso("AVICOT","100001",cTit,cMsg,__aGDVFOR[nPosFor,6],cCopia,nil,nil,.F.)
                        conout("MT131WF[006] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao+" - Token: "+cToken)
                    Else
                        MsgStop("MT131WF [TCSQLError]: "+TCSQLError())
                    Endif
                Endif
            Endif
            (cAls)->(dbSkip())
        Enddo
        GDVDB():queryEnd(cAls)
    Else
        conout("MT131WF[007] "+dtos(MsDate())+" "+Time()+" > Cotacao "+cCotacao+" - Nao passou pela rotina do portal - Type('__aGDVFOR') = "+Type("__aGDVFOR"))
    Endif
Return
