#include "protheus.ch"

// *********************************************************************** //
// MT120SCR - Ponto de entrada para inicializar pedido de compra           //
// @copyright (c) 2020-09-11 > Marcelo da Cunha > GDVIEW                   //
// *********************************************************************** //

User Function MT120SCR()
    ********************
    LOCAL nx, ny, cItem := "0001", aRefImpos := {}, aItens := {}
    LOCAL nPLoc := GDFieldPos("C7_LOCAL"), nPNop := GDFieldPos("C7_OP")
    LOCAL cBkpReadVar := ReadVar() //Backup ReadVar
    If (Type("__a025SCS") == "A").and.(Len(__a025SCS) > 0)
        dbSelectArea("SC7")
        RegToMemory("SC7",.T.)
        aRefImpos := MaFisRelImp('MT100',{"SC7"})
        aCols := {}
        MaFisEnd()
        MaFisIni(ca120Forn,ca120Loj,"F","N",Nil,aRefImpos,,.T.)
        SC1->(dbSetOrder(1))
        For nx := 1 to Len(__a025SCS)
            If SC1->(dbSeek(xFilial("SC1")+__a025SCS[nx,1]+__a025SCS[nx,2])).and.(SC1->C1_quant > SC1->C1_quje).and.Empty(SC1->C1_residuo)
                aadd(aCols,Array(Len(aHeader)+1))
                N := Len(aCols)
                For nY := 1 to Len(aHeader)
                    If (Trim(aHeader[nY][2]) == "C7_ITEM")
                        aCols[Len(aCols)][nY] := cItem
                        cItem := Soma1(cItem)
                    Elseif (Trim(aHeader[nY][2]) == "C7_PRODUTO")
                        aCols[Len(aCols)][nY] := SC1->C1_produto
                    Elseif (Trim(aHeader[nY][2]) == "C7_LOCAL")
                        aCols[Len(aCols)][nY] := SC1->C1_local
                    Elseif (Trim(aHeader[nY][2]) == "C7_DESCRI")
                        aCols[Len(aCols)][nY] := SC1->C1_descri
                    Elseif (Trim(aHeader[nY][2]) == "C7_QUANT")
                        aCols[Len(aCols)][nY] := (SC1->C1_quant-SC1->C1_quje)
                    Elseif (Trim(aHeader[nY][2]) == "C7_DATPRF")
                        aCols[Len(aCols)][nY] := SC1->C1_datprf
                    Elseif (Trim(aHeader[nY][2]) == "C7_NUMSC")
                        aCols[Len(aCols)][nY] := SC1->C1_num
                    Elseif (Trim(aHeader[nY][2]) == "C7_ITEMSC")
                        aCols[Len(aCols)][nY] := SC1->C1_item
                    Elseif (Trim(aHeader[nY][2]) == "C7_OP")
                        aCols[Len(aCols)][nY] := SC1->C1_op
                    Elseif (Trim(aHeader[nY][2]) == "C7_ALI_WT")
                        aCols[Len(aCols)][nY] := "SC7"
                    Elseif (Trim(aHeader[nY][2]) == "C7_REC_WT")
                        aCols[Len(aCols)][nY] := 0
                    Elseif (aCols[Len(aCols)][nY] == Nil)
                        aCols[Len(aCols)][nY] := CriaVar(aHeader[nY][2])
                    Endif
                    aCols[Len(aCols)][Len(aHeader)+1] := .F.
                Next nY
                aItens := aClone(aCols)
                MaFisAdd(GDFieldGet("C7_PRODUTO"),;	// 1-Codigo do Produto ( Obrigatorio )
                "",;	   							// 2-Codigo do TES ( Opcional )
                GDFieldGet("C7_QUANT"),;  	        // 3-Quantidade ( Obrigatorio )
                GDFieldGet("C7_PRECO"),;		    // 4-Preco Unitario ( Obrigatorio )
                GDFieldGet("C7_VLDESC"),;  	        // 5-Valor do Desconto ( Opcional )
                "",;	   							// 6-Numero da NF Original ( Devolucao/Benef )
                "",;								// 7-Serie da NF Original ( Devolucao/Benef )
                0,;									// 8-RecNo da NF Original no arq SD1/SD2
                0,;									// 9-Valor do Frete do Item ( Opcional )  FERNANDO: 23/10/2013 RETIRADO nValFre,;
                0,; 								// 10-Valor da Despesa do item ( Opcional )
                0,;									// 11-Valor do Seguro do item ( Opcional )
                0,;									// 12-Valor do Frete Autonomo ( Opcional )
                GDFieldGet("C7_TOTAL"),; 		    // 13-Valor da Mercadoria ( Obrigatorio )   Fernando: 23/10/2013
                0)					   			    // 14-Valor da Embalagem ( Opiconal )
            Endif
        Next nx
        For nx := 1 to Len(aCols)
            N := nx
            //PRODUTO
            __READVAR := "M->C7_PRODUTO"
            M->C7_PRODUTO := GDFieldGet("C7_PRODUTO")
            MaFisRef("IT_PRODUTO","MT120",M->C7_PRODUTO)
            If ExistTrigger("C7_PRODUTO")
                RunTrigger(2,N,,"C7_PRODUTO")
            EndIf
            A120Produto(M->C7_PRODUTO)
            A120Tabela("M->C7_PRODUTO",M->C7_PRODUTO)
            //QUANTIDADE
            __READVAR := "M->C7_QUANT"
            M->C7_QUANT := GDFieldGet("C7_QUANT")
            MaFisRef("IT_QUANT","MT120",M->C7_QUANT)
            If ExistTrigger("C7_QUANT")
                RunTrigger(2,N,,"C7_QUANT")
            Endif
            A120Quant(M->C7_QUANT)
            A120Tabela("M->C7_QUANT",M->C7_QUANT)
            //PRECO
            __READVAR := "M->C7_PRECO"
            M->C7_PRECO := GDFieldGet("C7_PRECO")
            MaFisRef("IT_PRCUNI","MT120",M->C7_PRECO)
            If ExistTrigger("C7_PRECO")
                RunTrigger(2,N,,"C7_PRECO")
            EndIf
            A120Preco(M->C7_PRECO)
            //TOTAL
            __READVAR := "M->C7_TOTAL"
            M->C7_TOTAL := M->C7_QUANT*M->C7_PRECO
            MaFisRef("IT_VALMERC","MT120",M->C7_TOTAL)
            If ExistTrigger("C7_TOTAL")
                RunTrigger(2,N,,"C7_TOTAL")
            EndIf
            A120Total(M->C7_TOTAL)
            //LOCAL
            If (nPLoc > 0)
                aCols[nx,nPLoc] := aItens[nx,nPLoc]
            Endif
            //OP
            If (nPNop > 0)
                aCols[nx,nPNop] := aItens[nx,nPNop]
            Endif
        Next nx
        MaColsToFis(aHeader,aCols,Nil,"MT120",.T.)
        Eval(bGDRefresh)
        Eval(bRefresh)
        __READVAR := cBkpReadVar
    Endif
Return
