#include "protheus.ch"
#include "fwmvcdef.ch"

// *********************************************************************** //
// MATA035 - Ponto de entrada para gravar alteracoes no grupo de produtos  //
// @copyright (c) 2022-11-21 > Marcelo da Cunha > GDVIEW                   //
// *********************************************************************** //

User Function MATA035()
    *********************
    LOCAL lRetu := .T., aRetu := {}, oModel, nOperation := 0
    If (Type("paramixb[2]") == "C").and.(Alltrim(paramixb[2]) == "BUTTONBAR")
        aadd(aRetu,{"Historico","HISTO",{|| u_GDVHistMan("SBM") },nil})
        Return aRetu
    Elseif (Type("paramixb[2]") == "C").and.(Alltrim(paramixb[2]) == "FORMPOS")
        If ExistBlock("GDVHCOMPARA").and.(Type("paramixb[1]") == "O")
            oModel := paramixb[1]
            nOperation := oModel:GetOperation()
            INCLUI := (nOperation == MODEL_OPERATION_INSERT)
            ALTERA := (nOperation == MODEL_OPERATION_UPDATE)
            RegToMemory("SBM",.T.)
            setMemoryVars(@oModel)
            u_GDVHCompara("SBM") //Comparo alteracoes no grupo de produtos
        Endif
    Endif
    If (Type("paramixb") == "U")
        If (lRetu).and.ExistBlock("GDVHCOMPARA")
            u_GDVHCompara("SBM")
        Endif
    Endif
Return lRetu

Static Function setMemoryVars(xModel)
    *********************************
    LOCAL nx, uValue, aCampos := xModel:GetStruct():GetFields()
    For nx := 1 to Len(aCampos)
        uValue := xModel:GetValue(aCampos[nx,3])
        If (uValue != nil)
            &("M->"+Alltrim(aCampos[nx,3])) := uValue
        Endif
    Next nx
Return
