#include "protheus.ch"
#include "fwmvcdef.ch"

// *********************************************************************** //
// CTBA040 - Ponto de entrada para gravar alteracoes no item contbil      //
// @copyright (c) 2018-07-16 > Marcelo da Cunha > GDVIEW                   //
// *********************************************************************** //

User Function CTBA040()
    *********************
    LOCAL lRetu := .T., aRetu := {}, oModel, nOperation := 0
    If (Type("paramixb[2]") == "C").and.(Alltrim(paramixb[2]) == "BUTTONBAR")
        aadd(aRetu,{"Historico","HISTO",{|| u_GDVHistMan("CTD") },nil})
        Return aRetu
    Elseif (Type("paramixb[2]") == "C").and.(Alltrim(paramixb[2]) == "FORMPOS")
        If ExistBlock("GDVHCOMPARA").and.(Type("paramixb[1]") == "O")
            oModel := paramixb[1]
            nOperation := oModel:GetOperation()
            INCLUI := (nOperation == MODEL_OPERATION_INSERT)
            ALTERA := (nOperation == MODEL_OPERATION_UPDATE)
            RegToMemory("CTD",.T.)
            setMemoryVars(@oModel)
            u_GDVHCompara("CTD") //Comparo alteracoes no centro de custo
        Endif
    Endif
    If (Type("paramixb") == "U")
        If (lRetu).and.ExistBlock("GDVHCOMPARA")
            u_GDVHCompara("CTD") //Comparo alteracoes item contabil
        Endif
    Endif
Return lRetu

Static Function setMemoryVars(xModel)
    *********************************
    LOCAL nx, uValue, aCampos := xModel:GetStruct():GetFields()
    For nx := 1 to Len(aCampos)
        uValue := xModel:GetValue(aCampos[nx,3])
        If (uValue != nil)
            &("M->"+Alltrim(aCampos[nx,3])) := uValue
        Endif
    Next nx
Return
