#include "protheus.ch"
#include "fwmvcdef.ch"

// *********************************************************************** //
// CTBA020 - Ponto de entrada para gravar alteracoes no plano de contas    //
// @copyright (c) 2018-07-14 > Marcelo da Cunha > GDVIEW                   //
// *********************************************************************** //

User Function CTBA020()
    *********************
    LOCAL lRetu := .T., aRetu := {}, oModel, nOperation := 0
    If (Type("paramixb[2]") == "C").and.(Alltrim(paramixb[2]) == "BUTTONBAR")
        aadd(aRetu,{"Historico","HISTO",{|| u_GDVHistMan("CT1") },nil})
        Return aRetu
    Elseif (Type("paramixb[2]") == "C").and.(Alltrim(paramixb[2]) == "FORMPOS")
        If ExistBlock("GDVHCOMPARA").and.(Type("paramixb[1]") == "O")
            oModel := paramixb[1]
            nOperation := oModel:GetOperation()
            INCLUI := (nOperation == MODEL_OPERATION_INSERT)
            ALTERA := (nOperation == MODEL_OPERATION_UPDATE)
            RegToMemory("CT1",.T.)
            setMemoryVars(@oModel)
            u_GDVHCompara("CT1") //Comparo alteracoes nas plano de contas
        Endif
    Endif
    If (Type("paramixb") == "U")
        If (lRetu).and.ExistBlock("GDVHCOMPARA")
            u_GDVHCompara("CT1") //Comparo alteracoes plano de contas
        Endif
    Endif
Return lRetu

Static Function setMemoryVars(xModel)
    *********************************
    LOCAL nx, uValue, aCampos := xModel:GetStruct():GetFields()
    For nx := 1 to Len(aCampos)
        uValue := xModel:GetValue(aCampos[nx,3])
        If (uValue != nil)
            &("M->"+Alltrim(aCampos[nx,3])) := uValue
        Endif
    Next nx
Return
